//
//  GSToolPlugin.h
//  GlyphsCore
//
//  Created by Georg Seifert on 27.01.10.
//  Copyright 2010 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <GlyphsCore/GSGlyphViewControllerProtocol.h>
#import <GlyphsCore/GSSelectableElementProtocol.h>
#import <GlyphsCore/GSWindowControllerProtocol.h>
#import <GlyphsCore/GlyphsToolProtocol.h>

@class GSLayer;
@class GSElement;
@class GSInspectorViewController;

NS_ASSUME_NONNULL_BEGIN

@interface GSToolPlugin : NSResponder <GlyphsTool> {
	__weak NSWindowController<GSWindowControllerProtocol> *_windowController;
	__weak NSViewController<GSGlyphEditViewControllerProtocol> *_editViewController;
	NSMutableDictionary<NSString *, GSInspectorViewController *> *_inspectorViewControllers;
}

- (nullable GSSelectableElement *)elementAtPoint:(NSPoint)loc atLayer:(GSLayer *)layer;

@end

NS_ASSUME_NONNULL_END
